/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.libs.repack_wishingforsunshine.noobutil.world.gen.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;
import noobanidus.libs.repack_wishingforsunshine.noobutil.types.LazyStateSupplier;
import noobanidus.libs.repack_wishingforsunshine.noobutil.types.LazySupplier;

public class SupplierBlockClusterFeatureConfig
implements IFeatureConfig {
    public static final Codec<SupplierBlockClusterFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.field_236796_a_.fieldOf("state_provider").forGetter(o -> o.stateProvider), (App)BlockPlacer.field_236435_a_.fieldOf("block_placer").forGetter(o -> o.blockPlacer), (App)LazyStateSupplier.CODEC.listOf().fieldOf("whitelist").forGetter(o -> ImmutableList.copyOf(o.whitelist)), (App)LazyStateSupplier.CODEC.listOf().fieldOf("blacklist").forGetter(o -> ImmutableList.copyOf(o.blacklist)), (App)Codec.INT.fieldOf("tries").orElse((Object)128).forGetter(o -> o.tryCount), (App)Codec.INT.fieldOf("xspread").orElse((Object)7).forGetter(o -> o.xSpread), (App)Codec.INT.fieldOf("yspread").orElse((Object)3).forGetter(o -> o.ySpread), (App)Codec.INT.fieldOf("zspread").orElse((Object)7).forGetter(o -> o.zSpread), (App)Codec.BOOL.fieldOf("can_replace").orElse((Object)false).forGetter(o -> o.isReplaceable), (App)Codec.BOOL.fieldOf("project").orElse((Object)true).forGetter(o -> o.project), (App)Codec.BOOL.fieldOf("need_water").orElse((Object)false).forGetter(o -> o.requiresWater)).apply((Applicative)instance, SupplierBlockClusterFeatureConfig::new));
    public final BlockStateProvider stateProvider;
    public final BlockPlacer blockPlacer;
    public final Set<LazyStateSupplier> whitelist;
    public final Set<LazyStateSupplier> blacklist;
    public final Set<Block> whitelistResolved = new HashSet<Block>();
    public final Set<BlockState> blacklistResolved = new HashSet<BlockState>();
    public final int tryCount;
    public final int xSpread;
    public final int ySpread;
    public final int zSpread;
    public final boolean isReplaceable;
    public final boolean project;
    public final boolean requiresWater;

    private SupplierBlockClusterFeatureConfig(BlockStateProvider stateProvider, BlockPlacer blockPlacer, List<LazyStateSupplier> whitelist, List<LazyStateSupplier> blacklist, int tries, int xSpread, int ySpread, int zSpread, boolean isReplaceable, boolean project, boolean requiresWater) {
        this(stateProvider, blockPlacer, (Set<LazyStateSupplier>)ImmutableSet.copyOf(whitelist), (Set<LazyStateSupplier>)ImmutableSet.copyOf(blacklist), tries, xSpread, ySpread, zSpread, isReplaceable, project, requiresWater);
    }

    private SupplierBlockClusterFeatureConfig(BlockStateProvider stateProvider, BlockPlacer blockPlacer, Set<LazyStateSupplier> whitelist, Set<LazyStateSupplier> blacklist, int tries, int xSpread, int ySpread, int zSpread, boolean isReplaceable, boolean project, boolean requiresWater) {
        this.stateProvider = stateProvider;
        this.blockPlacer = blockPlacer;
        this.whitelist = whitelist;
        this.blacklist = blacklist;
        this.tryCount = tries;
        this.xSpread = xSpread;
        this.ySpread = ySpread;
        this.zSpread = zSpread;
        this.isReplaceable = isReplaceable;
        this.project = project;
        this.requiresWater = requiresWater;
    }

    public Set<Block> getWhitelist() {
        if (this.whitelistResolved.isEmpty() && !this.whitelist.isEmpty()) {
            this.whitelist.stream().map(LazySupplier::get).map(AbstractBlock.AbstractBlockState::func_177230_c).forEach(this.whitelistResolved::add);
        }
        return this.whitelistResolved;
    }

    public Set<BlockState> getBlacklist() {
        if (this.blacklistResolved.isEmpty() && !this.blacklist.isEmpty()) {
            this.blacklist.stream().map(LazySupplier::get).forEach(this.blacklistResolved::add);
        }
        return this.blacklistResolved;
    }

    public static class Builder {
        private final BlockStateProvider stateProvider;
        private final BlockPlacer blockPlacer;
        private Set<LazyStateSupplier> whitelist = ImmutableSet.of();
        private Set<LazyStateSupplier> blacklist = ImmutableSet.of();
        private int tryCount = 64;
        private int xSpread = 7;
        private int ySpread = 3;
        private int zSpread = 7;
        private boolean isReplaceable;
        private boolean project = true;
        private boolean requiresWater = false;

        public Builder(BlockStateProvider stateProvider, BlockPlacer blockPlacer) {
            this.stateProvider = stateProvider;
            this.blockPlacer = blockPlacer;
        }

        public Builder whitelist(Set<LazyStateSupplier> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public Builder blacklist(Set<LazyStateSupplier> blacklist) {
            this.blacklist = blacklist;
            return this;
        }

        public Builder tries(int tries) {
            this.tryCount = tries;
            return this;
        }

        public Builder xSpread(int xSpread) {
            this.xSpread = xSpread;
            return this;
        }

        public Builder ySpread(int ySpread) {
            this.ySpread = ySpread;
            return this;
        }

        public Builder zSpread(int zSpread) {
            this.zSpread = zSpread;
            return this;
        }

        public Builder replaceable() {
            this.isReplaceable = true;
            return this;
        }

        public Builder noProjection() {
            this.project = false;
            return this;
        }

        public Builder requiresWater() {
            this.requiresWater = true;
            return this;
        }

        public SupplierBlockClusterFeatureConfig build() {
            return new SupplierBlockClusterFeatureConfig(this.stateProvider, this.blockPlacer, this.whitelist, this.blacklist, this.tryCount, this.xSpread, this.ySpread, this.zSpread, this.isReplaceable, this.project, this.requiresWater);
        }
    }
}

